<?php


class PersonnageManager{
    
    private $db;

    public function setDb(PDO $db){
        $this->db = $db;
    }

    public function __construct($db){
        $this->setDb($db);
    }

    

    public function getList(){
        $query = $this->db->query('SELECT * FROM Personnages ORDER BY id');

        while ($donnees = $query-> fetch(PDO::FETCH_ASSOC)){
            $personnages[] = new Personnage($donnees);
        }
        return $personnages;
    }


    public function getPerso($id){
        $id = (int) $id;

        $query = $this->db->query('SELECT * FROM Personnages WHERE id = ' . $id);
        $donnees = $query->fetch(PDO::FETCH_ASSOC);

        return new Personnage($donnees);
    }

    public function addPerso(Personnage $perso){

         // Récupération de l'ID du perso ajouté
         $persoId = $this->db->query('SELECT MAX(id) FROM Personnages')->fetchColumn() + 1;

        $perso->setId($persoId);
        $q = $this->db->prepare('INSERT INTO Personnages(name, atk, pv, img) VALUES(:name, :atk, :pv, :img)');

        $q->bindValue(':name', $perso->getName());
        $q->bindValue(':atk', $perso->getAtk());
        $q->bindValue(':pv', $perso->getPv());        
        $q->bindValue(':img', 'img/persos/perso' . $perso->getId(). '.png');

        $q->execute();

       

    if (isset($_FILES['img']) && $_FILES['img']['error'] === UPLOAD_ERR_OK) {
        $content_dir = 'img/persos/'; 
        $tmp_file = $_FILES['img']['tmp_name'];

        // Vérifie que le fichier a bien été téléchargé temporairement
        if (!is_uploaded_file($tmp_file)) {
            exit("Le fichier est introuvable.");
        }

        // Récupère l'extension du fichier et génère un nouveau nom pour le fichier
        $extension = strtolower(pathinfo($_FILES['img']['name'], PATHINFO_EXTENSION));
        $nouveauNom = 'perso' . $persoId . '.' . $extension;

        // Assure que le répertoire de destination existe, le crée s'il est inexistant
        if (!is_dir($content_dir) && !mkdir($content_dir, 0777, true)) {
            exit("Erreur lors de la création du répertoire d'images.");
        }

        // Tente de déplacer le fichier dans le répertoire cible
        if (!move_uploaded_file($tmp_file, $content_dir . $nouveauNom)) {
            exit("Erreur lors du déplacement du fichier.");
        }
    }
    }

}

?>