document.addEventListener('DOMContentLoaded', () => {


  const imgPreview = document.getElementById('img-preview');
  const inputImg = document.getElementById('input-img');

  if (inputImg) {
    inputImg.onchange = function () {
      imgPreview.src = window.URL.createObjectURL(inputImg.files[0]);
    };

    document.querySelector('.reset').addEventListener('click', function () {
      imgPreview.src = '';
      inputImg.value = '';
    });

  }

  let lignePerso = document.querySelectorAll('.ligne-personnage');
  let imgPerso = document.getElementById('img-info');
  let nomInfo = document.getElementById('nom-info');
  let attaqueInfo = document.getElementById('attaque-info');
  let pvInfo = document.getElementById('pv-info');

  lignePerso.forEach((ligne) => {
    ligne.addEventListener('click', () => {
      let idPerso = ligne.getAttribute('id');
      imgPerso.src = `img/persos/perso${idPerso}.png`;
      nomInfo.innerHTML = ligne.querySelector('.nom').innerHTML;
      attaqueInfo.innerHTML = ligne.querySelector('.attaque').innerHTML;
      pvInfo.innerHTML = ligne.querySelector('.pv').innerHTML;
    });
  });


  // Perso selectionné

  let listePerso = document.querySelectorAll('.perso');


  let imgPersoSelected = document.getElementById('img-perso-selected');
  let nomPersoSelected = document.getElementById('nom-perso-selected');
  let attaqueBarPersoSelected = document.getElementById('attaque-perso-selected');
  let pvBarPersoSelected = document.getElementById('pv-perso-selected');
  let attaquePersoSelected = document.getElementById('atk-progress-bar');
  let pvPersoSelected = document.getElementById('pv-progress-bar');

  let nomPerso;
  let attaquePerso;
  let pvPerso;
  let imgPersoSrc;

  listePerso.forEach((perso) => {
    perso.addEventListener('mouseover', () => {
      imgPersoSrc = perso.querySelector('img').src;
      nomPerso = perso.querySelector('#name-perso').innerHTML;
      attaquePerso = perso.querySelector('#atk-perso').innerHTML;
      pvPerso = perso.querySelector('#pv-perso').innerHTML;
      imgPersoSelected.src = imgPersoSrc;
      nomPersoSelected.innerHTML = nomPerso;
      attaqueBarPersoSelected.value = attaquePerso;
      pvBarPersoSelected.value = pvPerso;
      attaquePersoSelected.innerHTML = attaquePerso + '/100';
      pvPersoSelected.innerHTML = pvPerso + '/200';
    });
  });

});