<?php
session_start();
if (!isset($_SESSION['perso']) || !isset($_SESSION['adversaire'])) {
    $_SESSION['perso'] = $_GET['perso'];
    $_SESSION['adversaire'] = $_GET['adv'];
    $_SESSION['tour'] = 1;
    echo $_SESSION['tour'];
    $_SESSION['log'] = [];

    $_SESSION['perso_obj'] = serialize($MonManager->getPerso($_SESSION['perso']));
    $_SESSION['adv_obj'] = serialize($MonManager->getPerso($_SESSION['adversaire']));
}


// Récupération des objets
$perso = unserialize($_SESSION['perso_obj']);
$adv = unserialize($_SESSION['adv_obj']);
$tour = $_SESSION['tour'];

if (!isset($_SESSION['pv_max_perso'])) {
    echo $_SESSION['pv_max_perso'];
    $_SESSION['pv_max_perso'] = $perso->getPv();
}
if (!isset($_SESSION['pv_max_adv'])) {
    $_SESSION['pv_max_adv'] = $adv->getPv();
}

if (isset($_POST['action'])) {
    $attaquant = $tour % 2 === 1 ? $perso : $adv;
    $defenseur = $tour % 2 === 1 ? $adv : $perso;

    if ($_POST['action'] == "attack") {
        $attaquant->attaquer($defenseur);
        $resultat = "<strong>".$attaquant->getName()."</strong> attaque <strong>".$defenseur->getName()."</strong> de ".$attaquant->getAtk()." !";
    } elseif ($_POST['action'] == "defend") {
        $resultat = "<strong>".$attaquant->getName()."</strong> se met en défense.";
    } elseif ($_POST['action'] == "heal") {
            $soin = rand(5, 30);
            if ($tour % 2 === 1 && $soin > $_SESSION['pv_max_perso'] - $attaquant->getPv()) {
                $soin = $_SESSION['pv_max_perso'] - $attaquant->getPv();
            } elseif ($tour % 2 === 0 && $soin > $_SESSION['pv_max_adv'] - $attaquant->getPv()) {
                $soin = $_SESSION['pv_max_adv'] - $attaquant->getPv();
            }
            if ($soin > 0) {
            $attaquant->soigner($soin);
            $resultat = "<strong>".$attaquant->getName()."</strong> se soigne de ".$soin." PV.";
        } else {
            $resultat = "<strong>".$attaquant->getName()."</strong> est déjà au maximum de ses PV.";
        }  
        
    }

    $_SESSION['log'][] = $resultat;
    $_SESSION['tour']++;

    // Sauvegarde des nouveaux états
    $_SESSION['perso_obj'] = serialize($perso);
    $_SESSION['adv_obj'] = serialize($adv);

    // Vérifier si le combat est terminé
    if (!$perso->is_alive() || !$adv->is_alive()) {
        $_SESSION['log'][] = "<strong>" . ($perso->is_alive() ? $perso->getName() : $adv->getName()) . " a gagné !</strong>";
    }

    // Recharge la page pour afficher les mises à jour
    header("Location: index.php?action=combat&perso=".$_SESSION['perso']."&adv=".$_SESSION['adversaire']);
    exit();
}
?>

<video autoplay muted loop class="video">
    <source src="video/fond.mp4" type="video/mp4">
</video>


<header>
    <a href="index.php" class="retour">&lt; Accueil</a>
    <h1>Tour <span><?= $_SESSION['tour'] ?></span></h1>
    
</header>

<main>
    <?php if (!$perso->is_alive() || !$adv->is_alive()) : ?>
    <div class="popup">
        <h3>Fin du combat</h2>
        <p><strong><?= $perso->is_alive() ? $perso->getName() : $adv->getName() ?></strong> a gagné !</p>
        <a href="index.php">Retourner à l'accueil</a>
    </div>
    <?php endif; ?>

    <div class="combat-zone">
        <?php if (!$perso->is_alive()): ?>
            <div class="character dead">
        <?php elseif ($tour % 2 === 1): ?>
            <div class="character active">
        <?php else: ?>
            <div class="character">
        <?php endif; ?>
            <img src="<?= $perso->getImg() ?>" alt="<?= $perso->getName() ?>">
            <progress id="pv-perso1" value="<?= $perso->getPv() ?>" max=<?= $_SESSION['pv_max_perso'] ?>></progress>
            <?php if (!$perso->is_alive()): ?>
                <p>DEAD</p>
        <?php else: ?>
            <p><?= $perso->getPv() ?>/<?= $_SESSION['pv_max_perso'] ?></p>
        <?php endif; ?>
        </div>
        <h2><?=$perso->getName() ?> VS <?=$adv->getName() ?> </h2>
        <?php if (!$adv->is_alive()): ?>
            <div class="character dead">
        <?php elseif ($tour % 2 === 0): ?>
            <div class="character active">
        <?php else: ?>
            <div class="character">
        <?php endif; ?>
            <img src="<?= $adv->getImg() ?>" alt="<?= $adv->getName() ?>">
            <progress id="pv-perso2" value="<?= $adv->getPv() ?>" max=<?= $_SESSION['pv_max_adv'] ?>></progress>
            <?php if (!$adv->is_alive()): ?>
                <p>DEAD</p>
        <?php else: ?>
            <p><?= $adv->getPv() ?>/<?= $_SESSION['pv_max_adv'] ?></p>
        <?php endif; ?>
            
        </div>
    </div>

    <?php if ($perso->is_alive() && $adv->is_alive()) : ?>
    <form method="POST">
        <div class="controls">
            <button type="submit" name="action" value="attack">Attaquer</button>
            <button type="submit" name="action" value="defend">Se protéger</button>
            <button type="submit" name="action" value="heal">Soigner</button>
        </div>
    </form>
    <?php endif; ?>

    <div class="log">
        <?php
        $i=$_SESSION['tour']-1; 
        foreach (array_reverse($_SESSION['log']) as $log) : ?>
            <p><?=$i?> > <?= $log ?></p>
        <?php $i--; endforeach; ?>
        <p>> Le combat commence...</p>
    </div>

</main>
